#include <iostream>
#include <vector>
using namespace std;


vector<vector<int>> memo;
vector<int> P;

bool ne_znam_da_li_je_podniz_sortiran(int i, int j) 
{
    for (int k = i; k < j; k++) 
    {
        if (P[k] + 1 != P[k + 1] ) 
        {
            return false;
        }
    }
    return true;
}


int ne_znam_dinamicno_programiranje(int i, int j) 
{
    if (!(i < j)) 
    { 
        return 0;
    }
    if (memo[i][j] != -1) 
    {
        return memo[i][j];
    }

    if (ne_znam_da_li_je_podniz_sortiran(i, j)) 
    {
        return memo[i][j] = 0;
    }

    int cena = j - i;
    
    for (int k = i; k < j; k++) 
    {
        int cost_of_split = 1 + ne_znam_dinamicno_programiranje(i, k) + ne_znam_dinamicno_programiranje(k + 1, j);
        cena = min(cena, cost_of_split);
    }

    return memo[i][j] = cena;
}


int main() 
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    int N, Q; 
    cin >> N >> Q; 

    P.assign(N, 0);
    for (int i = 0; i < N; i++) 
    {
        cin >> P[i];
    }

    
    memo.assign(N, std::vector<int>(N, -1));
    if (N == 0) 
    {
        cout << 0 << "\n";
    }
    else 
    {
        cout << ne_znam_dinamicno_programiranje(0, N - 1) << "\n";
    }

    while(Q--)
    {
        int p1, p2;
        cin >> p1 >> p2; 
        p1--;
        p2--; 

        swap(P[p1], P[p2]);
        memo.assign(N, std::vector<int>(N, -1));
        if (N == 0) 
        {
            cout << 0 << "\n";
        }
        else 
        {
            cout << ne_znam_dinamicno_programiranje(0, N - 1) << "\n";
        }
    }

    return 0;
}